VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "War3Parse"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'FooL's Warcraft III Clan Parsing
Public myClan As String
Public amLeader As Boolean
Private cookie As Long
Public acceptInvite As Integer '0=default(msgbox) 1=autoaccept 2=autodecline
Public enabled As Boolean
Private ct As String * 4 'clan tag
Private cn As String 'clan name

Function ParseClanInfo(ByVal packetID As Integer, ByVal Data As String)  'returns whether the packet data is a valid WAR3 packet that is parsed
'On Error GoTo err:
'acceptInvite = 1
ParseClanInfo = True
'6=after 1 dword(cookie)
'2=start of data
Dim oRank As String, Stat As String
Select Case packetID
    Case &H70 'list of inviteable candidates
        'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        Select Case Asc(Mid$(Data, 9, 1)) 'status bye
            Case &H1
                frmMain.AddChat ">>[Clan] Clan Tag Already in Use", vbYellow
            Case &H2
                frmMain.AddChat ">>[Clan] You have already created a clan within the minimum time period", Orange
            Case &H3
                frmMain.AddChat ">>[Clan] Not enough members to create clan", Orange
            Case &HA
                frmMain.AddChat ">>[Clan] Invalid Clan Tag Specified", Orange
            Case &H8
                frmMain.AddChat ">>[Clan] You cannot create a clan(already in a clan?)", Orange
            Case &H0
            Dim userCount As Byte, Username As String, pos As Integer
                userCount = CInt(Asc(Mid$(Data, 10, 1)))
                pos = 11
                If userCount >= 9 Then
                        With tcp
                        Dim Cookietmp As String * 4
                        Cookietmp = Mid$(Data, 5, 4)
                            .InsertDWORD &H1 'cookie
                            frmMain.AddChat cn & ct
                            .InsertNTString cn
                            .InsertNonNTString MakeClanDWORDString(ct)
                            .InsertBYTE Asc(Mid$(Data, 10, 1))
                End With
                                    Else
                        frmMain.AddChat ">>[Clan] Not enough candidates were found(9 required).  Candidates Must be in the same channel and not already in a clan.", Orange
                End If
                frmMain.AddChat ">>[Clan] Potential Candidates:", LBlue, True
                For x = 1 To 9
                    Username = KillNull(Mid$(Data, pos))
                    frmMain.AddChat " " & Username, LBlue, True
                    If userCount >= 9 Then tcp.InsertNTString Username
                    pos = pos + Len(Username) + 1
                Next x
                    frmMain.AddChat " [" & userCount & "] candiates(" & Asc(Mid$(Data, 10, 1)) & ")", LBlue
                    If userCount >= 9 Then
                        frmMain.AddChat ">>[Clan] At least 9 Candidates found, Inviting users to join Clan[" & ct & "]", vbBlue
                        tcp.sendPacket &H71
                    End If
                    tcp.Clear
            Case Else
                frmMain.AddChat ">>[Clan] Clan Invitation List Exception", Orange: ParseClanInfo = False
            End Select
    Case &H71 'clan creation response
        'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        Select Case Asc(Mid$(Data, 6, 1))
            Case &H0
                frmMain.AddChat ">>[Clan] Clan Mass Invite Success!", vbGreen
            Case &H4
                frmMain.AddChat ">>[Clan] Clan Mass Invite Failed - A user declined", Orange, True
                Username = Mid$(Data, 7)
                frmMain.AddChat " [" & Username & "]", LGreen
            Case &H5
                frmMain.AddChat ">>[Clan] Cannot Invite(Not in channel or already in clan)", Orange, True
                Username = Mid$(Data, 7)
                frmMain.AddChat " [" & Username & "]", LGreen
            Case Else
                frmMain.AddChat ">>[Clan] Invalid Mass Invite Response", Orange: ParseClanInfo = False
            End Select
    Case &H72 'clan creation invite
        Dim tCook As String * 4
        'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        frmMain.AddChat ">>[Clan] You have been invited to create a clan!", vbYellow
        Dim clantag As String, creator As String, ClanName As String
        tCook = Mid$(Data, 5, 4) 'cookie
        ct = Mid$(Data, 9, 4) 'unmodified clan tag
        clantag = KillNull(StrReverse(Mid$(Data, 9, 4)))
        ClanName = KillNull(Mid$(Data, 13))
        pos = 14 + Len(ClanName) + 1
        creator = KillNull(Mid$(Data, pos))
        pos = pos + Len(creator) + 1
        frmMain.AddChat ">>[Clan] Clan Name: " & ClanName & " - Tag [" & clantag & "]", vbYellow
        userCount = CInt(Asc(Mid$(Data, pos, 1)))
                pos = pos + 1
                frmMain.AddChat ">>[Clan] Potential Candidates:", LBlue, True
                For x = 1 To userCount
                    Username = KillNull(Mid$(Data, pos))
                    frmMain.AddChat " " & Username, LBlue, True
                    pos = pos + Len(Username) + 1
                Next x
                frmMain.AddChat " [" & userCount & "] candiates", LBlue
        If acceptInvite = 0 Then
            res = MsgBox("You have been invited to join Clan: " & ClanName & "[" & clantag & "] by" & creator & vbCrLf & "Accept?", vbYesNo, "CLAN INVITE")
            If res = vbYes Then
                accp = True
            Else
                accp = False
            End If
        ElseIf acceptInvite = 1 Then
            accp = True
        Else
            accp = False
        End If
        With tcp
        If accp Then 'send invite response
            .InsertDWORD GetTickCount
            '.InsertNonNTString tCook 'unmodified cookie
            .InsertNonNTString ct 'unmodified clan tag
            .InsertNTString creator 'creator of clan
            '.InsertNTString ClanName
            .InsertBYTE &H6 'accept value
            .sendPacket &H72
            frmMain.AddChat ">>[Clan] You have accepted the Invitation", vbGreen
        Else
            .InsertDWORD GetTickCount
            '.InsertNonNTString tCook
            .InsertNonNTString ct
            .InsertNTString creator
            '.InsertNTString ClanName
            .InsertBYTE &H4
            .sendPacket &H72
            frmMain.AddChat ">>[Clan] You have declined the Invitation", vbRed
        End If
        End With
        'call CLAN CREATION INVITED
    Case &H73 'CLAN DISBAND RESPONSE
        'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        Select Case Asc(Right$(Data, 1))
            Case &H0
                frmMain.AddChat ">>[Clan] Clan Successfully Disbanded...", LBlue
            Case &H1
                frmMain.AddChat ">>[Clan] Clan Disbanding Exception", Orange
                ParseClanInfo = False
            Case &H2
                frmMain.AddChat ">>[Clan] Clan cannot be disbanded because it is less than 7 days old!", Orange
            Case Else
                frmMain.AddChat ">>[Clan] Clan Disbanding Unknown Exception", Orange
                ParseClanInfo = False
        End Select
    Case &H74 'respone from Chieftan TRANSFER
        'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        Select Case Asc(Right$(Data, 1))
            Case &H0
                frmMain.AddChat ">>[Clan] Chieftan Status Successfully Transferred", LBlue
            Case &H1
                frmMain.AddChat ">>[Clan] Chieftan Status Transfer Failed", Orange
            Case Else
                frmMain.AddChat ">>[Clan] Chieftan Transfer Unknown Exception", Orange
                ParseClanInfo = False
            End Select
    Case &H75 ' CLAN LOGON MESSAGE  >>WORKS
        oRank = getRank(Asc(Right$(Data, 1)))
        Dim clanStr As String
        'cookie = Asc(Mid$(data, 2, 4))
        clanStr = KillNull$(StrReverse(Mid$(Data, 6, 4)))
        'ct = Replace(ct, Chr(0), vbNullString)
        amLeader = False
        If oRank = "Shaman" Or oRank = "Chieftan" Then amLeader = True
        frmMain.AddChat "[Clan] you are a [" & oRank & "] in Clan [" & clanStr & "]", LBlue
        myClan = clanStr
    Case &H76 'have left clan
        'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        amLeader = False
        myClan = vbNullString
        frmMain.AddChat ">>[Clan] You have left the clan or have been removed", Orange
    Case &H77 'invite response
    'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        Select Case Asc(Right$(Data, 1))
           Case &H0
                frmMain.AddChat ">>[Clan] Clan invitation accepted", vbGreen
            Case &H1
                frmMain.AddChat ">>[Clan] Invalid User", Orange
            Case &H4
                frmMain.AddChat ">>[Clan] Invite Failed: User rejected the invitation", Orange
           Case &H5
                frmMain.AddChat ">>[Clan] Invite Failed: User is not in channel or is already in a clan", Orange
            Case &H7
                frmMain.AddChat ">>[Clan] Invite Failed: You do not have invite privileges", Orange
            Case &H8
                frmMain.AddChat ">>[Clan] Invite Failed: Cannot Invite User", Orange
            Case &H9
                frmMain.AddChat ">>[Clan] Cannot Invite, Clan is full.", Orange
            Case Else
                frmMain.AddChat ">>[Clan] Cannot Invite: Unknown Exception", Orange
                ParseClanInfo = False
        End Select
    Case &H78 'Someone has been removed from the clan
    'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        Select Case Asc(Right$(Data, 1))
            Case &H0
                frmMain.AddChat ">>[Clan] User Successfully Removed From Clan", vbGreen
            Case &H1
                frmMain.AddChat ">>[Clan] Remove User From Clan Failed", Orange
            Case &H7
                frmMain.AddChat ">>[Clan] You are not authorized to remove that user", Orange
            Case &H8
                frmMain.AddChat ">>[Clan] Cannot remove that user from the clan during the probation period", Orange
            Case Else
                frmMain.AddChat ">>[Clan] User Removal Failed", Orange
                ParseClanInfo = False
            End Select
    Case &H79 'CLAN INVITE
        Dim cl As String * 4, strCookie As String
        'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        'token = Asc(Mid$(data, 2, 4))
        ct = Mid$(Data, 5, 4) 'cookie
        clantag = KillNull(StrReverse(Mid$(Data, 9, 4)))
        cl = Mid$(Data, 9, 4) 'unmodified clan tag
        ClanName = KillNull(Mid$(Data, 13))
        pos = 14 + Len(ClanName)
        creator = KillNull(Mid$(Data, pos))
        frmMain.AddChat ">>[Clan] You have been invited to join Clan: " & ClanName & "[", vbYellow, True
        frmMain.AddChat clantag, Grey, True
        frmMain.AddChat "] by [", vbYellow, True
        frmMain.AddChat creator, LGreen, True
        frmMain.AddChat "]", vbYellow
        If acceptInvite = 0 Then
            res = MsgBox("You have been invited to join Clan: " & ClanName & "[" & clantag & "] by" & creator & vbCrLf & "Accept?", vbYesNo, "CLAN INVITE")
            If res = vbYes Then
                accp = True
            Else
                accp = False
            End If
        ElseIf acceptInvite = 1 Then
            accp = True
        Else
            accp = False
        End If
        With tcp
        If accp Then 'send invite response
            .InsertNonNTString ct
            .InsertNonNTString cl
            .InsertNTString creator
            .InsertBYTE &H6
            .sendPacket &H79
            frmMain.AddChat ">>[Clan] You have accepted the Invitation", vbGreen
        Else
            .InsertNonNTString ct
            .InsertNonNTString cl
            .InsertNTString creator
            .InsertBYTE &H4
            .sendPacket &H79
            frmMain.AddChat ">>[Clan] You have declined the Invitation", vbRed
        End If
        End With
        
        'call CLAN_INVITE
    Case &H7A 'PROMOTION REPLY
    'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        Select Case Asc(Right$(Data, 1))
            Case &H0
                frmMain.AddChat ">>[Clan] User Successfully Demoted/Promoted", vbGreen
            Case &H1
                frmMain.AddChat ">>[Clan] User Promote/Demote Failed", Orange
            Case &H7
                frmMain.AddChat ">>[Clan] You are not authorized to perform that rank change", Orange
            Case &H8
                frmMain.AddChat ">>[Clan] You cannot change the rank of users still in the 7-day probation period.", Orange
            Case Else
                frmMain.AddChat ">>[Clan] User Promote/Demote Exception", Orange
                ParseClanInfo = False
            End Select
    Case &H7B
        'shouldn't get this-a client to server only packet
        ParseClanInfo = False
    Case &H7C 'CLAN REQUEST MOTD RESPONSE
    'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        Dim motd As String
        motd = Mid$(Data, 9)
        frmMain.AddChat ">>[Clan] MOTD: " & motd, LBlue
    Case &H7D 'CLAN_LIST
        'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK(Clan LIST):" & Hex(packetID): parseclaninfo = False
        Call ParseClanList(Data)
    Case &H7E 'USER REMOVAL RESPONSE
    'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        Dim us As String
        us = Trim$(KillNull$(Mid$(Data, 5)))
        frmMain.AddChat ">>[Clan] User Removed From Clan List[" & us & "]", vbYellow
        StatusChange us, vbNullString, vbNullString
    Case &H7F 'USER UPDATE/STATUS
    'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        'user updated(either clan rank or online/offline)
        
        Username = KillNull(Mid$(Data, 5))
        pos = 6 + Len(Username)
        ran = Asc(Mid$(Data, pos, 1))
        pos = pos + 1
        Stat = Asc(Mid$(Data, pos, 1))
        pos = pos + 1
        res = Mid$(Data, pos)
        oRank = getRank(ran)
        Stat = getStatus(Stat)
        If DisClan Then frmMain.AddChat "[Clan] The status of [" & Username & "] has been changed to Rank[" & oRank & "] and [" & Stat & "]" & " " & res, LBlue
        StatusChange Username, oRank, Stat
        'If Beta Then AddChat "[BoT] Unknown Packet ID:" & Hex(packetid) & " Data: " & StrToHex(Data)
        'If Beta Then AddChat "[BoT] " & Data
    Case &H81
    'If Beta Then frmMain.AddChat "WAR3 PARSE CHECK:" & Hex(packetID): ParseClanInfo = False
        'your rank has been changed
        nrank = getRank(Asc(Mid$(Data, 6, 1)))
        oRank = getRank(Asc(Mid$(Data, 5, 1)))
        Username = KillNull(Mid$(Data, 7))
        frmMain.AddChat "[Clan] " & Username & " changed your rank from [" & oRank & "] to [" & nrank & "]", vbYellow
        amLeader = False
        If nrank = "Shaman" Or nrank = "Chieftan" Then amLeader = True
    Case Else
        ParseClanInfo = False
    End Select

End Function

Public Sub WC3Invite(Username As String)
With tcp
    .InsertDWORD &H1
    .InsertNTString Username
    .sendPacket &H77
    End With
End Sub
Public Sub WC3message(Message As String)
With tcp
    .InsertDWORD &H5
    .sendPacket &H7C
    .InsertDWORD &H0
    .InsertNTString Message
    .sendPacket &H7B
    .InsertDWORD &H5
    .sendPacket &H7C
        End With
End Sub
Public Sub WC3ChangeToShaman(Username As String)
With tcp
    .InsertDWORD &H2
    .InsertNTString Username
    .InsertBYTE &H3
    .sendPacket &H7A
        End With
End Sub
Public Sub WC3ChangeToGrunt(Username As String)
With tcp
    .InsertDWORD &HB
    .InsertNTString Username
    .InsertBYTE &H2
    .sendPacket &H7A
End With
End Sub
Public Sub WC3ChangeToPeon(Username As String)
With tcp
    .InsertDWORD &HB
    .InsertNTString Username
    .InsertBYTE &H1
    .sendPacket &H7A
End With
End Sub

Public Sub WC3Remove(Username As String)
With tcp
    .InsertDWORD &H2
    .InsertNTString Username
    .sendPacket &H78
End With
End Sub

Public Sub WC3demote(Username As String)
With tcp
    .InsertDWORD &H1
    .InsertNTString Username
    .InsertBYTE &H1
    .sendPacket &H7A
End With
End Sub

Public Sub WC3quit(Username As String)
With tcp
    .InsertDWORD &H1
    .InsertNTString Username
    .sendPacket &H78
End With
End Sub

Private Function getRank(r)
On Error Resume Next
oRank = "?Rank"
    Select Case r
            Case &H0
                oRank = "Peon(Probation Period)"
            Case &H1
                oRank = "Peon"
            Case &H2
                oRank = "Grunt"
            Case &H3
                oRank = "Shaman"
            Case &H4
                oRank = "Chieftan"
    End Select
    getRank = oRank
End Function

Sub requestClanList()
With tcp
.InsertDWORD &H5 'cookie?
.sendPacket &H7D
End With
End Sub


Sub ParseClanList(ByVal Data As String)

Dim numMembers As Integer
Dim user As String, Rank As String, pos As Integer, Status As String
numMembers = Asc(Mid$(Data, 9, 1))
If DisClan Then frmMain.AddChat ">>[Clan] Your Clan Has [" & numMembers & "] members", LBlue

frmMain.lstClan.ListItems.Clear 'clear clan list


Dim cl As New ClanList
pos = 10
'us = Split(data, Chr(0))
    Dim shamanIndex As Integer 'used to keep track of how to place users in the clan tab
    Dim shamanCount As Integer
    Dim gruntCount As Integer
    'Dim peonCount As Integer
    shamanIndex = 1
While pos < Len(Data)
    user = KillNull(Mid$(Data, pos))
    pos = pos + Len(user) + 1
    Rank = getRank(Asc(Mid$(Data, pos, 1)))
    Status = getStatus(Asc(Mid$(Data, pos + 1, 1)))
    Unknown = Asc(Mid$(Data, pos + 2, 1))
    pos = pos + 3
    If autoClanRank Then clanAccessCheck user, Rank, Status
    'add to clan listview
    Dim Index As Integer
    With frmMain.lstClan
        Select Case Rank 'pick place in clan list based on rank
            Case "Chieftan"
                Index = 1
                shamanIndex = 2 'bump back placement for shaman
            Case "Shaman"
                Index = shamanIndex
                shamanCount = shamanCount + 1
            Case "Grunt"
                gruntCount = gruntCount + 1
                Index = shamanIndex + shamanCount
            Case "Peon"
                'peoncont = peonCount + 1
                Index = shamanIndex + shamanCount + gruntCount
            Case Else
                Index = .ListItems.count + 1
        End Select
        .ListItems.add Index, , user, Rank, Rank
    .ListItems.Item(Index).ListSubItems.add , , , Status, Status
    .ListItems.Item(Index).tag = Rank
    .ListItems.Item(Index).ToolTipText = "(" & Rank & ") " & user & " - " & Status
    cl.addMember user
    End With
Wend
If Not autoClanRank Then Exit Sub
Dim c() As String
c = cl.getClanList
If numMembers > 0 Then clearNotInClan c
Exit Sub
End Sub

Private Function getStatus(ByVal Stat)
Select Case Stat
            Case &H0
                Stat = "Offline"
            Case &H1
                Stat = "Online"
            Case &H2
                Stat = "In Channel"
            Case &H3
                Stat = "In Public Game"
            Case &H5
                Stat = "In Private Game"
            Case Else
                Stat = "Unknown Status"
        End Select
getStatus = Stat
End Function

Public Sub CreateClan(clantag As String, ClanName As String) 'lol
'first we must send 0x70 to check for canditates
'tcp.dbug = True
'Dim inCT As String
ct = clantag
cn = Trim(ClanName)
cn = ClanName
'MsgBox "ct" & ct & "ct"
'MsgBox "st" & StrReverse(ct) & "ct"
With tcp
    .InsertDWORD &H0 'cookie
    .InsertNonNTString MakeClanDWORDString(ct)
    .sendPacket &H70
End With
frmMain.AddChat ">>[Clan Creation] Checking status of Clan Tag and looking for Potential Candidates...", vbYellow
End Sub

Private Function MakeClanDWORDString(ByVal clantag As String) As String
clantag = Trim(StrReverse(clantag))
Dim cp As String * 4
If Len(clantag) = 1 Then clantag = Chr(0) & clantag
If Len(clantag) = 2 Then clantag = Chr(0) & clantag
If Len(clantag) = 3 Then clantag = Chr(0) & clantag
cp = clantag
MakeClanDWORDString = cp
End Function

Private Sub StatusChange(ByVal Username As String, Rank As String, Status As String)
Dim x As Integer
With frmMain.lstClan
If .ListItems.count = 0 Then Exit Sub
    For x = 1 To .ListItems.count
        If LCase$(.ListItems.Item(x).Text) = LCase$(Username) Then 'found the user, remove and readd them them
            .ListItems.remove x 'erase
            If Rank = vbNullString Then Exit Sub 'no rank=removal of user
            .ListItems.add x, , Username, Rank, Rank
            .ListItems.Item(x).ListSubItems.add , , , Status, Status
            .ListItems.Item(x).tag = Rank
            .ListItems.Item(x).ToolTipText = "(" & Rank & ") " & Username & " - " & Status
            Exit Sub
        End If
    Next x

'hm, havn't found them, so we should add them
x = .ListItems.count + 1
.ListItems.add x, , Username, Rank, Rank
    .ListItems.Item(x).ListSubItems.add , , , Status, Status
    .ListItems.Item(x).tag = Rank
    .ListItems.Item(x).ToolTipText = "(" & Rank & ") " & Username & " - " & Status
End With
End Sub
